<?php

namespace App\Http\Controllers;

use App\BuyMoney;
use App\Category;
use App\Continent;
use App\Country;
use App\Currency;
use Response;
use App\Coin;
use App\ExchangeMoney;
use App\Faq;
use App\GeneralSettings;
use App\Internet;
use App\Internetbundle;
use App\Message;
use App\Bill;
use App\Power;
use App\Decoder;
use App\Decodersub;
use App\Mentor;
use App\Menu;
use App\Post;
use App\Apibuy;
use App\User;
use App\SellMoney;
use App\Service;
use App\Subscriber;
use App\Apibill;
use App\Testimonial;
use Illuminate\Http\Request;

class DeveloperController extends Controller
{
    public function developerapiairtimes($api, $network, $number, $amount)
    {
      $userp = User::whereToken($api)->count();
      if($userp < 1){
      return "Wrong Developer API Key";
      }
      $user = User::whereToken($api)->first();

       if($user->developer < 1){
        $response =  (array('status'=>'Declined', 'reason' => 'You dont have Developer API permision yet. Please contact admin for permission'));
           return $response;
       }

       if($user->developer > 0){
        if($user->balance < $amount){
         $response =  (array('status'=>'Declined', 'reason' => 'Insufficient API Balance'));
           return $response;
        }

       $user->balance = $user->balance - $amount;
       $user->save();

        $trx = substr(str_shuffle('ABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890') , 0 , 10 );

              Apibill::create([
                    'user_id' => $user->id,
                    'amount' => $amount,
                    'phone' => $number,
                    'trx' => $trx,
                    'network' => $network,
                    'newbalance' => $user->balance,
                    'type' => 'Airtime',
                    'status' => 'Successful',
                ]);
        $basic = GeneralSettings::first();
        $network2 = Internet::whereId($network)->count();
          if($network2 < 1){
           $response =  (array('status'=>'Declined', 'reason' => 'Wrong Network or Plan Code'));
           return $response;
          }
        $network2 = Internet::find($network);
        $api_id = $basic->merchantid;
        $api_key = $basic->merchantkey;

        $baseUrl = "https://www.nellobytesystems.com";
        $endpoint = "/APIAirtimeV1.asp?UserID=".$api_id."&APIKey=".$api_key."&MobileNetwork=".$network2."&Amount=".$amount."&MobileNumber=".$number."&CallBackURL=#";
        $httpVerb = "GET";
        $contentType = "application/json"; //e.g charset=utf-8
        $headers = array (
            "Content-Type: $contentType",

        );

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_URL, $baseUrl.$endpoint);
            curl_setopt($ch, CURLOPT_HTTPGET, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $content = json_decode(curl_exec( $ch ),true);
            $err     = curl_errno( $ch );
            $errmsg  = curl_error( $ch );
        	curl_close($ch);




        $response =  (array('status'=>'Successful', 'phone' => $number, 'amount' =>$amount, 'network' => $network2->name, 'trx_id' => $trx));
        return $response;
        }



    }


    public function developerapiairtimequery($api, $trx)
    {
      $userp = User::whereToken($api)->count();
      if($userp < 1){
      $response =  (array('status'=>'Declined', 'reason' => 'Wrong Developer API Key'));
           return $response;
      }

      $user = User::whereToken($api)->first();

       if($user->developer < 1){
         $response =  (array('status'=>'Declined', 'reason' => 'You dont have Developer API permision yet. Please contact admin for permission'));
           return $response;
       }



      $query = Apibill::whereType("Airtime")->whereTrx($trx)->count();
       if($query < 1){
       $response =  (array('status'=>'Declined', 'reason' => 'Wrong Transaction Number'));
           return $response;
      }


        $query = Apibill::whereType("Airtime")->whereTrx($trx)->first();
        $response =  (array('status'=> $query->status, 'type' => $query->type, 'amount' =>$query->amount, 'network' => $query->network, 'phone' => $query->phone, 'trx_id' => $query->trx, 'date' => $query->created_at));
        return $response;
        }



      public function developerapiinternetdata($api, $network, $plan, $number)
    {
      $userp = User::whereToken($api)->count();
      if($userp < 1){
       $response =  (array('status'=>'Declined', 'reason' => 'Wrong Developer API Key'));
           return $response;
      }
      $user = User::whereToken($api)->first();

       if($user->developer < 1){
        $response =  (array('status'=>'Declined', 'reason' => 'You dont have Developer API permision yet. Please contact admin for permission'));
           return $response;
       }
         $bundle = Internetbundle::whereCode($network)->wherePlan($plan)->count();
          if($bundle < 1){
           $response =  (array('status'=>'Declined', 'reason' => 'Wrong Network Code or Internet Data Plan Code'));
           return $response;
          }

        $bundle = Internetbundle::whereCode($network)->wherePlan($plan)->first();
        $network2 = Internet::find($network);


        if($user->developer > 0){
        if($user->balance < $bundle->cost){
          $response =  (array('status'=>'Declined', 'reason' => 'Insufficient API Balance'));
           return $response;
        }

       $user->balance = $user->balance - $bundle->cost;
       $user->save();

        $trx = substr(str_shuffle('ABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890') , 0 , 10 );

              Apibill::create([
                    'user_id' => $user->id,
                    'plan' => $bundle->name,
                    'amount' => $bundle->cost,
                    'phone' => $number,
                    'trx' => $trx,
                    'network' => $network,
                    'newbalance' => $user->balance,
                    'type' => 'Internet Data',
                    'status' => 'Successful',
                ]);
        $basic = GeneralSettings::first();


        $api_id = $basic->merchantid;
        $api_key = $basic->merchantkey;

        $baseUrl = "https://www.nellobytesystems.com";
        $endpoint = "/APIDatabundleV1.asp?UserID=".$api_id."&APIKey=".$api_key."&MobileNetwork=".$network."&DataPlan=".$bundle."&MobileNumber=".$number."&CallBackURL=#";
        $httpVerb = "GET";
        $contentType = "application/json"; //e.g charset=utf-8
        $headers = array (
            "Content-Type: $contentType",

        );

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_URL, $baseUrl.$endpoint);
            curl_setopt($ch, CURLOPT_HTTPGET, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $content = json_decode(curl_exec( $ch ),true);
            $err     = curl_errno( $ch );
            $errmsg  = curl_error( $ch );
        	curl_close($ch);




        $response =  (array('status'=>'Successful', 'phone' => $number, 'plan' =>$bundle->name, 'network' => $network2->name, 'trx_id' => $trx));
        return $response;
        }
        }




    public function developerapidataquery($api, $trx)
    {
      $userp = User::whereToken($api)->count();
      if($userp < 1){
      $response =  (array('status'=>'Declined', 'reason' => 'Wrong Developer API Key'));
           return $response;
      }

      $user = User::whereToken($api)->first();

       if($user->developer < 1){
         $response =  (array('status'=>'Declined', 'reason' => 'You dont have Developer API permision yet. Please contact admin for permission'));
           return $response;
       }



      $query = Apibill::whereType("Internet Data")->whereTrx($trx)->count();
       if($query < 1){
       $response =  (array('status'=>'Declined', 'reason' => 'Wrong Transaction Number'));
           return $response;
      }


        $query = Apibill::whereType("Internet Data")->whereTrx($trx)->first();
        $response =  (array('status'=> $query->status, 'type' => $query->type, 'amount' =>$query->amount, 'network' => $query->network, 'phone' => $query->phone, 'trx_id' => $query->trx, 'date' => $query->created_at));
        return $response;
        }


    public function developerapicabletv_verify($api, $decoder, $number)
    {
      $userp = User::whereToken($api)->count();
      if($userp < 1){
      $response =  (array('status'=>'Declined', 'reason' => 'Wrong Developer API Key'));
           return $response;
      }

      $user = User::whereToken($api)->first();

       if($user->developer < 1){
        $response =  (array('status'=>'Declined', 'reason' => 'You dont have Developer API permision yet. Please contact admin for permission'));
           return $response;
        }



        $basic = GeneralSettings::first();
        $api_id = $basic->merchantid;
        $api_key = $basic->merchantkey;

        $baseUrl = "https://www.nellobytesystems.com";
        $endpoint = "/APIVerifyCableTVV1.0.asp?UserID=".$api_id."&APIKey=".$api_key."&cabletv=".$decoder."&smartcardno=".$number."";

        $httpVerb = "GET";
        $contentType = "application/json"; //e.g charset=utf-8
        $headers = array (
            "Content-Type: $contentType",

        );

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_URL, $baseUrl.$endpoint);
            curl_setopt($ch, CURLOPT_HTTPGET, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $content = json_decode(curl_exec( $ch ),true);
            $err     = curl_errno( $ch );
            $errmsg  = curl_error( $ch );
        	curl_close($ch);
			$result = implode(', ', (array)$content);

		  if ($result == "INVALID_SMARTCARDNO"){
		      $response =  (array('status'=>'Declined', 'reason' => 'Invalid Decoder Number'));
           return $response;
            }

			 $response =  (array('status'=>'Successful', 'name' => $result));
            return $response;
      }


    public function developerapicable_tv($api, $decoder, $plan, $number)
    {
      $userp = User::whereToken($api)->count();
      if($userp < 1){
      $response =  (array('status'=>'Declined', 'reason' => 'Wrong Developer API Key'));
           return $response;
      }

      $user = User::whereToken($api)->first();

       if($user->developer < 1){
        $response =  (array('status'=>'Declined', 'reason' => 'You dont have Developer API permision yet. Please contact admin for permission'));
           return $response;
        }

        $bundle = Decodersub::whereCode($decoder)->wherePlan($plan)->first();
        $network2 = Decoder::find($decoder);

          $query =  Decodersub::whereCode($decoder)->wherePlan($plan)->count();
           if($query < 1){
           $response =  (array('status'=>'Declined', 'reason' => 'Wrong Decoder Number'));
               return $response;
           }


        if($user->balance < $bundle->cost){
          $response =  (array('status'=>'Declined', 'reason' => 'Insufficient API Balance'));
           return $response;
        }

        $basic = GeneralSettings::first();
        $api_id = $basic->merchantid;
        $api_key = $basic->merchantkey;

        $baseUrl = "https://www.nellobytesystems.com";
        $endpoint = "/APICableTVV1.asp?UserID=".$api_id."&APIKey=".$api_key."&CableTV=".$decoder."&Package=".$plan."&SmartCardNo=".$number."&CallBackURL=http://www.your-website.com";

        $httpVerb = "GET";
        $contentType = "application/json"; //e.g charset=utf-8
        $headers = array (
            "Content-Type: $contentType",

        );

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_URL, $baseUrl.$endpoint);
            curl_setopt($ch, CURLOPT_HTTPGET, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $content = json_decode(curl_exec( $ch ),true);
            $err     = curl_errno( $ch );
            $errmsg  = curl_error( $ch );
        	curl_close($ch);
			$result = implode(', ', (array)$content);

		  if ($result == "INVALID_SMARTCARDNO"){
		      $response =  (array('status'=>'Declined', 'reason' => 'Invalid Decoder Number'));
           return $response;
            }


           else{
              $user->balance = $user->balance - $bundle->cost;
              $user->save();

             $trx = substr(str_shuffle('ABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890') , 0 , 10 );

              Apibill::create([
                    'user_id' => $user->id,
                    'plan' => $bundle->name,
                    'amount' => $bundle->cost,
                    'phone' => $number,
                    'trx' => $trx,
                    'network' => $decoder,
                    'newbalance' => $user->balance,
                    'type' => 'TV Subscription',
                    'status' => 'Successful',
                ]);

		     $response =  (array('status'=>'Successful', 'Number' => $number, 'plan' =>$bundle->name, 'network' => $network2->name, 'trx_id' => $trx));
             return $response;

            }}

     public function developerapicable_tvquery($api, $trx)
    {
      $userp = User::whereToken($api)->count();
      if($userp < 1){
      $response =  (array('status'=>'Declined', 'reason' => 'Wrong Developer API Key'));
           return $response;
      }

      $user = User::whereToken($api)->first();

       if($user->developer < 1){
         $response =  (array('status'=>'Declined', 'reason' => 'You dont have Developer API permision yet. Please contact admin for permission'));
           return $response;
       }



      $query = Apibill::whereType("TV Subscription")->whereTrx($trx)->count();
       if($query < 1){
       $response =  (array('status'=>'Declined', 'reason' => 'Wrong Transaction Number'));
           return $response;
      }


        $query = Apibill::whereType("TV Subscription")->whereTrx($trx)->first();
        $response =  (array('status'=> $query->status, 'type' => $query->type, 'decoder_number' =>$query->phone, 'decoder_type' => $query->network, 'decoder_plan' => $query->plan, 'trx_id' => $query->trx, 'date' => $query->created_at));
        return $response;
        }


          public function developerapielectricity_verify($api, $company, $number)
    {
      $userp = User::whereToken($api)->count();
      if($userp < 1){
      $response =  (array('status'=>'Declined', 'reason' => 'Wrong Developer API Key'));
           return $response;
      }

      $user = User::whereToken($api)->first();

       if($user->developer < 1){
        $response =  (array('status'=>'Declined', 'reason' => 'You dont have Developer API permision yet. Please contact admin for permission'));
           return $response;
        }



        $basic = GeneralSettings::first();
        $api_id = $basic->merchantid;
        $api_key = $basic->merchantkey;

        $baseUrl = "https://www.nellobytesystems.com";
         $endpoint = "/APIVerifyElectricityV1.asp?UserID=".$api_id."&APIKey=".$api_key ."&ElectricCompany=".$company."&meterno=".$number."";

        $httpVerb = "GET";
        $contentType = "application/json"; //e.g charset=utf-8
        $headers = array (
            "Content-Type: $contentType",

        );

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_URL, $baseUrl.$endpoint);
            curl_setopt($ch, CURLOPT_HTTPGET, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $content = json_decode(curl_exec( $ch ),true);
            $err     = curl_errno( $ch );
            $errmsg  = curl_error( $ch );
        	curl_close($ch);
			$result = implode(', ', (array)$content);

		  if ($result == "INVALID_METERNO"){
		      $response =  (array('status'=>'Declined', 'reason' => 'Invalid Meter Number'));
           return $response;
            }

		  if ($result == ""){
		      $response =  (array('status'=>'Declined', 'reason' => 'We Cant Process Your Request At The Momoent'));
           return $response;
            }

            if ($result == "INVALID_ElectricCompany"){

          $response =  (array('status'=>'Declined', 'reason' => 'Invalid Electricity Company'));
           return $response;

		 }

			 $response =  (array('status'=>'Successful', 'name' => $result));
            return $response;
         }



    public function developerapielectricity_buy($api, $company, $type, $number, $amount)
    {
      $userp = User::whereToken($api)->count();
      if($userp < 1){
      $response =  (array('status'=>'Declined', 'reason' => 'Wrong Developer API Key'));
           return $response;
      }

      $user = User::whereToken($api)->first();

       if($user->developer < 1){
        $response =  (array('status'=>'Declined', 'reason' => 'You dont have Developer API permision yet. Please contact admin for permission'));
           return $response;
        }

        $bundle = Power::whereCode($company)->first();

          $query =  Power::whereCode($company)->count();
           if($query < 1){
           $response =  (array('status'=>'Declined', 'reason' => 'Wrong Electricity Company'));
               return $response;
           }


        if($user->balance < $amount){
          $response =  (array('status'=>'Declined', 'reason' => 'Insufficient API Balance'));
           return $response;
        }

        $basic = GeneralSettings::first();
        $api_id = $basic->merchantid;
        $api_key = $basic->merchantkey;

        $baseUrl = "https://www.nellobytesystems.com";
         $endpoint = "/APIElectricityV1.asp?UserID=".$api_id."&APIKey=".$api_key."&ElectricCompany=".$company."&MeterType=".$type."&MeterNo=".$number."&Amount=".$amount."&CallBackURL=http://www.your-website.com";

        $httpVerb = "GET";
        $contentType = "application/json"; //e.g charset=utf-8
        $headers = array (
            "Content-Type: $contentType",

        );

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_URL, $baseUrl.$endpoint);
            curl_setopt($ch, CURLOPT_HTTPGET, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $content = json_decode(curl_exec( $ch ),true);
            $err     = curl_errno( $ch );
            $errmsg  = curl_error( $ch );
        	curl_close($ch);
			$result = implode(', ', (array)$content);

              $user->balance = $user->balance - $bundle->cost;
              $user->save();

             $trx = substr(str_shuffle('ABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890') , 0 , 10 );

              Apibill::create([
                    'user_id' => $user->id,
                    'plan' => $type,
                    'amount' => $amount,
                    'phone' => $number,
                    'trx' => $trx,
                    'network' => $bundle->name,
                    'newbalance' => $user->balance,
                    'type' => 'Electricity Bill',
                    'status' => 'Successful',
                ]);

		     $response =  (array('status'=>'Successful', 'Number' => $number, 'company' =>$bundle->name, 'type' => $type, 'trx_id' => $trx));
             return $response;

            }



     public function developerapielectricityquery($api, $trx)
    {
      $userp = User::whereToken($api)->count();
      if($userp < 1){
      $response =  (array('status'=>'Declined', 'reason' => 'Wrong Developer API Key'));
           return $response;
      }

      $user = User::whereToken($api)->first();

       if($user->developer < 1){
         $response =  (array('status'=>'Declined', 'reason' => 'You dont have Developer API permision yet. Please contact admin for permission'));
           return $response;
       }



      $query = Apibill::whereType("Electricity Bill")->whereTrx($trx)->count();
       if($query < 1){
       $response =  (array('status'=>'Declined', 'reason' => 'Wrong Transaction Number'));
           return $response;
      }


        $query = Apibill::whereType("Electricity Bill")->whereTrx($trx)->first();
        $response =  (array('status'=> $query->status, 'meter_type' => $query->type, 'meter_number' =>$query->phone, 'company' => $query->network, 'amount' => $query->amount, 'trx_id' => $query->trx, 'date' => $query->created_at));
        return $response;
        }














}
